% -------------------------------------------------------------------
% Este script hace la figura en la que se resuelve la ecuacin para
% la descomposicin de una especie radiactiva usando el mtodo de Euler,
% el mtodo Leapfrog y el mtodo de Runge-Kutta para el mismo tamao de paso
% Este script requiere que en el espacio de trabajo exista la
% funcin feuler, fLeapfrog y fRK4
% dy/dx = f(x,y;k) = - k*y:
% -------------------------------------------------------------------

%Definiciones y parmetros

k=1;
fun = @(t,y) -k*y;
y0=100;
t0=0;
tf=5;
Nh=10;

%Solucin usando el mtodo de Euler

[te,ye]=feuler(fun,t0,tf,y0,Nh);

%Solucin usando el mtodo Leapfrog

[tl,yl]=fLeapfrog(fun,t0,tf,y0,Nh);

%Solucin usando el mtodo de Runge-Kutta de cuarto orden

[trk,yrk]=fRK4(fun,t0,tf,y0,Nh);

%Solucin exacta

tp=0:0.1:5;
yp=y0*exp(-k*tp);

%Dibujamos todas las soluciones

plot(tp,yp,te,ye,'or',tl,yl,'+k',trk,yrk,'ok');
xlabel('t');
ylabel('N');
title('Comparativa Euler-Leapfrog-RK4');
legend('Sol. exacta','Mtodo Euler','Mtodo Leapfrog','Mtodo RK4');
text(2,70,'k=1, Nh=10');
